<?php


/**
 * 
 * The admin-specific functionality of the plugin.
 *
 * @link       https://arinspace.com
 * @since      1.0.0
 *
 * @package    Arinspace
 * @subpackage Arinspace/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Arinspace
 * @subpackage Arinspace/admin
 * @author     Auteur <info@arinspace.com>
 */


 function create_qrcode_file($urlid, $modelname)
	{
		$qrdataurl=ARINSPACE_MAIN_URL.'/Xrmodel/ShowModel/'.$urlid;

		$qrdata =array( 'id' => $urlid, 'url' => $qrdataurl);
		
		$qrurl =ARINSPACE_MAIN_URL."/Xrmodel/GetQRCode";
			
		$qrresp = wp_remote_post($qrurl, array(
			'body'    => $qrdata,
			'method'      => 'POST',
			'timeout'     => 45
			));

		if($qrresp['headers']['content-length']!="0")
		{
			$upload_dir = wp_upload_dir();
			$image_data = $qrresp['body'];
			
			$filename = 'ARInSpace_'.$modelname.'_QRcode.png';
			
			if ( wp_mkdir_p( $upload_dir['path'] ) ) {
			$file = $upload_dir['path'] . '/' . $filename;
			}
			else {
			$file = $upload_dir['basedir'] . '/' . $filename;
			}
			
			file_put_contents( $file, $image_data );
			
			$wp_filetype = wp_check_filetype( $filename, null );
			
			$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_title' => sanitize_file_name( $filename ),
			'post_content' => '',
			'post_status' => 'inherit'
			);
			
			$attach_id = wp_insert_attachment( $attachment, $file );
			require_once( ABSPATH . 'wp-admin/includes/image.php' );
			$attach_data = wp_generate_attachment_metadata( $attach_id, $file );
			wp_update_attachment_metadata( $attach_id, $attach_data );
		}

	}

class Arinspace_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Arinspace_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Arinspace_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/arinspace-admin.css', array(), $this->version, 'all' );
        wp_enqueue_style( 'arinspace-bootstrap', ARINSPACE_MAIN_URL.'/css/bootstrap.css', array(), $this->version, 'all' );
        wp_enqueue_style( 'arinspace-site',ARINSPACE_MAIN_URL.'/css/site.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'arinspace-jqueryui',ARINSPACE_MAIN_URL.'/css/jquery-ui.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'arinspace-datatables',ARINSPACE_MAIN_URL.'/css/jquery.datatables.min.css', array(), $this->version, 'all' );
		
		wp_enqueue_style( 'arinspace-googlefont','https://fonts.googleapis.com/icon?family=Material+Icons', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Arinspace_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Arinspace_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( 'arinspace-bootstrap', ARINSPACE_MAIN_URL.'/lib/jquery/dist/jquery.min.js', array( 'jquery' ), $this->version, false );
		
		wp_enqueue_script( 'arinspace-bootstrap',ARINSPACE_MAIN_URL.'/js/bootstrap.bundle.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( 'arinspace-qrcode',ARINSPACE_MAIN_URL.'/js/qrcode.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( 'arinspace-jqueryui',ARINSPACE_MAIN_URL.'/js/jquery.datatables.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( 'arinspace-datatables',ARINSPACE_MAIN_URL.'/js/jquery-ui.min.js', array( 'jquery' ), $this->version, false );
		
		if ($_GET['page'] == "arinspace_edit_page") {
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/arinspace-admin.js', array( 'jquery' ), $this->version, false );
		}


		if ($_GET['page'] == "arinspace_modeledit_page") {
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/arinspace-modeledit.js', array( 'jquery' ), $this->version, false );
			wp_enqueue_script( 'arinspace-threejs', ARINSPACE_MAIN_URL.'/js/three/three.js', array( 'jquery' ), $this->version, false );
			wp_enqueue_script( 'arinspace-threejsorbitcontrols',ARINSPACE_MAIN_URL.'/js/three/orbitcontrols.js', array( 'jquery' ), $this->version, false );
			wp_enqueue_script( 'arinspace-threecode', ARINSPACE_MAIN_URL.'/js/Xrmodel/ThreeCode.min.js', array( 'jquery' ), $this->version, false );		
		
			wp_localize_script( $this->plugin_name, 'arinspace_objects',
			array(
			  'modelkey' => $_GET['urlid'],
			  'arinspacemainurl' => ARINSPACE_MAIN_URL,		  
			  'lockzoomlabel'=>__("Lock zoom", ARINSPACE_TEXT_DOMAIN),
			  'unlockzoomlabel'=>__("Unlock zoom", ARINSPACE_TEXT_DOMAIN)
		  )
		);
		
		}




	}

	
	

	/**
	 * Add ARinSpace admin menu.
	 *
	 * @since    1.0.0
	 */
	public function arinspace_admin_menu() {
		add_menu_page("ARinSpace","ARinSpace", "administrator", "arinspace_edit_page", array($this, "arinspace_admin_page"),"dashicons-logo" );
	
		add_submenu_page(null, "ARinSpace", "ARinSpace","administrator","arinspace_modeledit_page", array($this, "arinspace_modeledit_page"));
	
	}

	public function arinspace_admin_page()
    {
        require_once("partials/arinspace-admin-display.php");
    }

	public function arinspace_modeledit_page()
    {
        require_once("partials/arinspace-model-edit.php");
    }


	/**
     * Register custom fields for plugin settings.
     *
     * @since    1.0.0
     */

 	public function register_arinspace_settings()
    {
        register_setting('arinspacesettings','arinspaceapikey' );
		register_setting('arinspacesettings','arinspaceaddpage' );

    }

	
	

	public function create_qrcode_files($option_name) {
		if ($option_name =='arinspaceapikey' ) {
			
			$arinspaceapikey =get_option("arinspaceapikey");

			$data =array( 'id' => $arinspaceapikey);
			$url = ARINSPACE_MAIN_URL."/Xrmodel/GetUserModels";
			
			$resp = wp_remote_post($url, array(
				'body'    => $data,
				'method'      => 'POST',
				'timeout'     => 45
				));

			$models = json_decode($resp["body"]);

			foreach ($models as $currmodel) 
			{					
				$modelname= $currmodel->xrmodelName;
				$urlid= $currmodel->urlid;
				create_qrcode_file($urlid,$modelname);				
			}
		}		
	}
	
	
	
}
