let xrobjects = {};
let bannertexts = {};

const lockZoomLabel = arinspace_objects.lockzoomlabel;
const unlockZoomLabel = arinspace_objects.unlockzoomlabel;

(function( $ ) {
	'use strict';


	let arinspace_main_url = arinspace_objects.arinspacemainurl;
	let arinspace_model_key = arinspace_objects.modelkey;
	

	
	let show_model_url = arinspace_main_url + "/Xrmodel/ShowModel/" + arinspace_model_key;
	let get_model_json_url =  arinspace_main_url + "/Xrmodel/GetModelDescription/";



	let arinspace_qr_text = show_model_url;
	let arinspace_qr_size = 256;

	

	$(document).ready(function () {
		
		$("#showmodelurl").attr("href", show_model_url);
		$("#showmodelurl").text(show_model_url);
		var qrcode = createQRCode();		
		qrcode.makeCode(arinspace_qr_text);

		$.post(get_model_json_url, { id: arinspace_model_key })
		.done(function( data ) {
			  xrobjects =data;
			  init();

			  for (var key in xrobjects) {
				  reloadTexture(xrobjects[key].id);
			  }

			  animate();
		});
	});

	function createQRCode() {
		var qrcode = new QRCode("qrcode", {
			width: arinspace_qr_size,
			height: arinspace_qr_size,
			colorDark: "#000000",
			colorLight: "#ffffff",
			correctLevel: QRCode.CorrectLevel.H
		});

		return qrcode;
	}	

})(jQuery);


function copyAPIKey() {
	const el = document.createElement('textarea');
	el.value = document.querySelector("#showmodelurl").innerHTML;
	el.setAttribute('readonly', '');
	el.style.position = 'absolute';
	el.style.left = '-9999px';
	document.body.appendChild(el);
	el.select();
	document.execCommand('copy');
	document.body.removeChild(el);
}


function downloadARinSpaceQRImage() {
	let dataUrl = document.querySelector('#qrcode').querySelector('img').src;
	downloadURI(dataUrl, 'qrcode.png');
}

function downloadURI(uri, name) {
	var link = null;
	link = document.createElement("a");
	link.download = name;
	link.href = uri;
	document.body.appendChild(link);
	link.click();
	document.body.removeChild(link);
};


