<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://arinspace.com
 * @since      1.0.0
 *
 * @package    Arinspace
 * @subpackage Arinspace/admin/partials
 */

    $arinspaceapikey =get_option("arinspaceapikey");

    $data =array( 'id' => $arinspaceapikey);

    $url = ARINSPACE_MAIN_URL."/Xrmodel/GetUserModels";
    
    $resp = wp_remote_post($url, array(
        'body'    => $data,
        'method'      => 'POST',
        'timeout'     => 45
        ));

    $models = json_decode($resp["body"]);
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->

<div class="container">
    <main role="main" class="pb-3">
        <div class="d-flex justify-content-center">
            <div class="card" style="width:100%">
                <div class="card-body" style="padding:0px;">                 
                    <form method="post" action="options.php">
                        <?php
                        settings_fields('arinspacesettings');
                        do_settings_sections('arinspacesettings');

                        $arinspaceaddpage = get_option('arinspaceaddpage');

                        ?>
                        <div class="row">
                            <div class="col">
                                <label for="arinspaceapikey" class="control-label">
                                    <?= _e('API key', ARINSPACE_TEXT_DOMAIN)?>
                                </label>
                            </div>                                   
                        </div>
                        <div class="row mb-3">
                            <div class="col-sm-12">
                                <input class="form-control" type="text" id="arinspaceapikey" name="arinspaceapikey" value="<?php echo get_option("arinspaceapikey"); ?>" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <a href="<?=ARINSPACE_MAIN_URL?>/Home/MyAPIKey" target="_blank" class="btn btn-secondary">
                                    <?= _e('Get my API key', ARINSPACE_TEXT_DOMAIN)?>
                                </a>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <p>*<?= _e('Due to security reasons you will be asked to login at ARinSpace website', ARINSPACE_TEXT_DOMAIN)?></p>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col">
                               
                                <button type="submit" class="btn btn-primary float-end">
                                    <?= _e('Save', ARINSPACE_TEXT_DOMAIN)?>
                                </button>                            
                            </div> 
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col">
                <h2>&nbsp;</h2>
            </div>
          
        </div>

        <div class="row mb-3">
            <div class="col">
                <h5><?= _e('My models', ARINSPACE_TEXT_DOMAIN)?></h5>
            </div>
        </div>


<div class="row  mb-3">
    <div class="col">
        <table class="table">
                <thead>
                    <tr>
                        <th><?= _e('ID', ARINSPACE_TEXT_DOMAIN)?></th>
                        <th><?= _e('Model name', ARINSPACE_TEXT_DOMAIN)?></th>          
                        <th><?= _e('Last published', ARINSPACE_TEXT_DOMAIN)?></th>            
                        <th><?= _e('License', ARINSPACE_TEXT_DOMAIN)?></th>
                        <th><?= _e('Valid till', ARINSPACE_TEXT_DOMAIN)?></th>                       
                        <th ></th>
                    </tr>
                </thead>
        <?php
            foreach ($models as $currmodel) {
               
                $datelastpublished = strtotime($currmodel->lastPublished);
                $datelicensevalidtill = strtotime($currmodel->licenseValidTill);
                ?>
                <tr>
                    <td><?=$currmodel->id?></td>
                    <td><?=$currmodel->xrmodelName?></td>
                    <td><?=date_i18n("d F Y (H:i)", $datelastpublished)?></td>
                    <td><?=$currmodel->licenseName?></td>
                    <td><?=date_i18n("d F Y", $datelicensevalidtill)?></td>
                    <td>
                        <a href="<?php echo menu_page_url("arinspace_modeledit_page", false)?>&&urlid=<?=$currmodel->urlid?>&&id=<?=$currmodel->id?>"  class="btn btn-primary"><div class="material-icons">edit</div></a> |
                        <a href="<?=ARINSPACE_MAIN_URL?>/Xrmodel/ShowModel/<?=$currmodel->urlid?>" target="_blank" class="btn btn-primary"><div class="material-icons">visibility</div></a>
                    
                    </td>
                </tr>
        <?php
            }
        ?>
        </table>

        </div>
        </div>


    </main>
</div>








