<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://arinspace.com
 * @since      1.0.0
 *
 * @package    Arinspace
 * @subpackage Arinspace/admin/partials
 */

 $urlid= $_GET['urlid'];
 $id = $_GET['id'];
 $fn ='';

 $data =array( 'id' => $urlid);
 $url = ARINSPACE_MAIN_URL."/Xrmodel/GetUserModel";
 
 $resp = wp_remote_post($url, array(
     'body'    => $data,
     'method'      => 'POST',
     'timeout'     => 45
     ));

 $currmodel = json_decode($resp["body"]);
 $modelname= $currmodel->xrmodelName;


 if(array_key_exists('fn', $_GET)) 
 {
    $fn =$_GET['fn'];
    if($fn === 'printQR')
    {   
         create_qrcode_file($urlid, $modelname);   
         $updateurl= menu_page_url("arinspace_modeledit_page", false).'&&urlid='.$urlid.'&&id='.$id;
         echo("<script>location.href = '".$updateurl."'</script>");
    }   
 }

 $editurl = ARINSPACE_MAIN_URL.'/Xrmodel/Edit/'.$id;


 if(isset( $urlid) and  $urlid!= false) :
    $myurl = ARINSPACE_MAIN_URL.'/Xrmodel/ShowModel/'. $urlid;

?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->

<div class="container">
    <main role="main" class="pb-3">

    <div class="row m-3">  
        <div class="col-6">
            <h3><?php echo $modelname ?></h3>
        </div> 
        <div class="col-6">
            <a href="<?php echo  menu_page_url("arinspace_edit_page", false);?>" class="btn btn-secondary active float-end" role="button"> <?= _e('Back to the list with models', ARINSPACE_TEXT_DOMAIN)?></a>
        </div>
    </div>

        <div class="row">
            <div class="col-md-6 col-sm-12">
                <a href="#" class="btn btn-primary" value="lock" id="lockzoom" onclick="lockZoom()" role="button" data-bs-toggle="button" style="position:absolute;margin:5px;"><div class="material-icons">lock</div><?= _e('Lock zoom', ARINSPACE_TEXT_DOMAIN)?></a>

                <div id="threecontainer"></div>
            </div>
            <div class="col-md-6 col-sm-12">
                <div class="row m-3">
                    <div class="col-12 d-flex justify-content-center">
                        <div id="qrcode"></div>
                    </div>
                </div>

                <div class="row m-3">
                    <div class="col-md-6 col-sm-12 d-flex justify-content-center">
                        <a href="#" onclick="downloadARinSpaceQRImage()" class="btn btn-outline-secondary">
                            <?= _e('Download image', ARINSPACE_TEXT_DOMAIN)?>
                        </a>
                    </div>
                    <div class="col-md-6 col-sm-12 d-flex justify-content-center">
                        <a href="<?php echo menu_page_url("arinspace_modeledit_page", false)?>&&fn=printQR&&urlid=<?=$urlid?>&&id=<?=$id?>"  class="btn btn-outline-secondary">
                            <?= _e('Add to media library', ARINSPACE_TEXT_DOMAIN)?>
                        </a>
                    </div>
                </div>

                <div class="row">
                    <div class="col">
                        <label for="arinspaceapikey" class="col-form-label">
                            <?= _e('My model URL', ARINSPACE_TEXT_DOMAIN)?>
                        </label>
                    </div>
                </div>
                <div class="row">
                    <div class="col">
                        <a href="#" name="showmodelurl" id="showmodelurl" target="_blank">
                            
                        </a>
                    </div>
                  
                </div>
              
                <div class="row mt-3">
                    <div class="col">
                        <a href="#" onclick="copyAPIKey()" class="btn btn-outline-secondary float-end">
                            <span class="material-icons">content_copy</span><?= _e('Copy',ARINSPACE_TEXT_DOMAIN)?>
                        </a>
                    </div>
                   
                </div>

                <div class="row mt-3">
                    <div class="col">
                        <a href="<?= $editurl?>" target="_blank" class="btn btn-secondary">
                            <?= _e('Edit my model', ARINSPACE_TEXT_DOMAIN)?>
                        </a>
                    </div>
                </div>
                <div class="row">
                            <div class="col-sm-12">
                                <p>*<?= _e('Due to security reasons you will be asked to login at ARinSpace website', ARINSPACE_TEXT_DOMAIN)?></p>
                            </div>
                        </div>


               
            </div>
           
        </div>      

        <?php endif; ?>

    </main>
</div>








