<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://arinspace.com
 * @since             1.0.0
 * @package           Arinspace
 *
 * @wordpress-plugin
 * Plugin Name:       ARinSpace
 * Plugin URI:        https://arinspace.com
 * Description:       Show your AR model on your site
 * Version:           1.0.5
 * Author:            ARinSpace
 * Author URI:        https://arinspace.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       arinspace
 * Domain Path:       /languages
 */



// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Custom constants.
 */
define( 'ARINSPACE_PAGE_SLUG', 'arinspacepage' );
define( 'ARINSPACE_MAIN_URL', 'https://webar.arinspace.com' );
define( 'ARINSPACE_TEXT_DOMAIN', 'arinspace' );


/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'ARINSPACE_VERSION', '1.0.0' );


/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-arinspace-activator.php
 */
function activate_arinspace() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-arinspace-activator.php';
	Arinspace_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-arinspace-deactivator.php
 */
function deactivate_arinspace() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-arinspace-deactivator.php';
	Arinspace_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_arinspace' );
register_deactivation_hook( __FILE__, 'deactivate_arinspace' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-arinspace.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_arinspace() {

	$plugin = new Arinspace();
	$plugin->run();

}
run_arinspace();
