<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://arinspace.com
 * @since      1.0.0
 *
 * @package    Arinspace
 * @subpackage Arinspace/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Arinspace
 * @subpackage Arinspace/includes
 * @author     Auteur <info@arinspace.com>
 */
class Arinspace_Deactivator {

	/**
	 * Short Description. (use period)

	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		 unregister_setting('arinspacesettings','arinspaceapikey' );
		 unregister_setting('arinspacesettings','arinspaceaddpage' );

		 delete_option('arinspaceapikey');
		 delete_option('arinspaceaddpage');

		 $page = get_page_by_path(ARINSPACE_PAGE_SLUG , OBJECT );

         if ( isset($page) )
         {
             wp_delete_post($page->ID,true);
         }
	}

}
