<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://arinspace.com
 * @since      1.0.0
 *
 * @package    Arinspace
 * @subpackage Arinspace/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Arinspace
 * @subpackage Arinspace/public
 * @author     Auteur <info@arinspace.com>
 */
class Arinspace_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Arinspace_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Arinspace_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/arinspace-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Arinspace_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Arinspace_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/arinspace-public.js', array( 'jquery' ), $this->version, false );

	}


		/**
	 * Add ARinSpace admin menu.
	 *
	 * @since    1.0.0
	 */
	public function arinspace_public_menu() {

		$page = get_page_by_path(ARINSPACE_PAGE_SLUG , OBJECT );

		$arinspaceaddpage=get_option("arinspaceaddpage");
		$arinspaceapikey=get_option("arinspaceapikey");

		$showmodelurl =  ARINSPACE_MAIN_URL."/Xrmodel/ShowModel/".$arinspaceapikey;

		if($arinspaceaddpage == true)
        {
            if (! isset($page) )
            {
                $new_page = array(
                    'post_type' => 'page',
                    'post_title' => 'ARinSpace',
                    'post_name' =>ARINSPACE_PAGE_SLUG,
                    'post_content'=>'<script>window.location.href = "'.$showmodelurl.'";</script>',
                    'post_status'       =>  'publish'
                    );
                wp_insert_post($new_page);
            }
        }
		else
        {
            if ( isset($page) )
            {
                wp_delete_post($page->ID,true);
            }
        }
	}

	public function arinspace_public_page()
    {
        require_once("partials/arinspace-public-display.php");
    }


}
